﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title></title>

	<script runat="server">

		public class DuplikatContext : ContextBase
		{

			public DuplikatContext(Context cx)
				: base(cx)
			{
			}

			bool duplikat = true;

			[Caption("Duplikat")]
			public bool Duplikat
			{
				get { return duplikat; }
				set { duplikat = value; }
			}

		}

		static readonly string divider = @"<pre  style=""line-height: 1; margin: 0 0 0 0;"">" + new string('-', 80) + "</pre>";
		static readonly string longdivider = @"<small><pre>" + new string('-', 130) + "</pre></small>";

		void OnContextLoading(Object sender, EventArgs args)
		{
			DokumentHandlowy d = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
			if (d == null) return;

			if (d.Stan != StanDokumentuHandlowego.Bufor)
			{
				if (!dc.Context.Contains(typeof(ParametryWydrukuDokumentu.Zatwierdzany)))
					dc.AddRequiredType(typeof(DuplikatContext));
			}
		}

		bool duplikat = false;
		DokumentHandlowy dokument;
		CoreModule core;
		string clC = "Cena       ";
		string clW = "Wartość       ";

		void OnContextLoad(Object sender, EventArgs args)
		{
			///////////////////////////////////////////////
			// Inicjacja pól
			//
			if (dc.Context.Contains(typeof(DuplikatContext)))
				duplikat = ((DuplikatContext)dc[typeof(DuplikatContext)]).Duplikat;

			dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
			core = CoreModule.GetInstance(dc);

			string nazwa;

			if (dokument.Definicja.SumyVAT != SposobLiczeniaSumVAT.NieLiczyć)
			{
				//Jeżeli dokumenty liczone od brutto, to wymieniamy nagłówki
				if (dokument.OdBrutto)
				{
					clC = "Cena brutto";
					clW = "Wartość brutto";
				}
				else
				{
					clC = "Cena netto ";
					clW = "Wartość netto ";
				}
				nazwa = "faktury";
			}
			else
				nazwa = "rachunku";
			clC = HttpUtility.HtmlEncode(clC);
			clW = HttpUtility.HtmlEncode(clW);

            var pieczątka = core.Config.Firma.Pieczątka;
            var BDO = pieczątka.BDO;
             BDOFirmyS.EditValue = "    BDO: " + BDO;

            if(String.IsNullOrWhiteSpace(BDO))
            BDOFirmyS.Visible = false;

			string[] t = core.Config.Firma.Pieczątka.NazwaWieleLinii;
			for (int i = 0; i < t.Length; ++i)
				t[i] = HttpUtility.HtmlEncode(t[i]);
			DataLabel8.EditValue = string.Join("<br>&nbsp;&nbsp;&nbsp;&nbsp;", t);
			DataLabel9.EditValue = HttpUtility.HtmlEncode(core.Config.Firma.AdresSiedziby.Linia1);
			DataLabel10.EditValue = HttpUtility.HtmlEncode(core.Config.Firma.AdresSiedziby.Linia2);

			if (dokument.DaneKontrahenta != null)
			{
				DataLabel14.EditValue = dokument.DaneKontrahenta.NazwaFormatowana;
				DataLabel15.EditValue = HttpUtility.HtmlEncode(dokument.DaneKontrahenta.Adres.Linia1);
				DataLabel16.EditValue = HttpUtility.HtmlEncode(dokument.DaneKontrahenta.Adres.Linia2);
			}

			//    if (dokument.DaneOdbiorcy!=null) {
			//	DataLabel18.EditValue = multiLineEncode(dokument.DaneOdbiorcy.NazwaFormatowana);
			//	DataLabel19.EditValue = HttpUtility.HtmlEncode(dokument.DaneOdbiorcy.Adres.Linia1);
			//	DataLabel20.EditValue = HttpUtility.HtmlEncode(dokument.DaneOdbiorcy.Adres.Linia2);
			//	}

			fvc = 0;
			poc = 0;

			DokZalRepeater.DataSource = dokument.DokumentyZaliczkowe;
			ZalRepeater.DataSource = dokument.Zaliczki;
			innyPlatnik = dokument.InnyPłatnik;

			_Vat();

			_Płatności();

			_Stopka(nazwa);

        lDataEtykieta.Visible = lData.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleData;
        lDataDostawyEtykieta.Visible = lDataDostawy.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataDostawy;
        lDataOperacjiEtykieta.Visible = lDataOperacji.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOperacji;
        lDataOtrzymaniaEtykieta.Visible = lDataOtrzymania.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOtrzymania;

		ObcyKorygowany.Visible = dokument.DokumentyKorygowanePierwsze.Any(x => !string.IsNullOrEmpty(x.Obcy.Numer));

		}

		string multiLineEncode(string s)
		{
			string[] t = s.Split('\n');
			for (int i = t.Length; --i >= 0; )
				t[i] = HttpUtility.HtmlEncode(t[i]);
			return string.Join("<br>&nbsp;&nbsp;&nbsp;&nbsp;", t);
		}

		int fvc;
		int poc;

		void FvBodyRepeater_BeforeRow(Object sender, EventArgs e)
		{
			PozycjaDokHandlowego pozycja = (PozycjaDokHandlowego)FvBodyRepeater.CurrentRow;
			fv_body.EditValue =
				"|" + Right(++fvc, 3) +
				"|" + Left(pozycja.NazwaPierwszaLinia, 40) +
				"|" + Right(pozycja.Cena, 16) +
				"|" + Right(pozycja.Ilosc.Value, 10) +
				" " + Left(pozycja.Ilosc.Symbol, 4) +
				"|" + Right(pozycja.Rabat, 6) +
				"|" + Right(pozycja.WartoscCy, 16) +
				"|" + Center(pozycja.DefinicjaStawki, 10) +
				"|" + Left(pozycja.SWW, 15) +
				"|\r";
		}

		void PrzedBodyRepeater_BeforeRow(Object sender, EventArgs e)
		{
			PozycjaDokHandlowego pozycjaOryginalna = (PozycjaDokHandlowego)PrzedBodyRepeater.CurrentRow;
            PozycjaDokHandlowego pozycja = pozycjaOryginalna.PozycjaKorygowana;

            bool drukuj = !pozycjaOryginalna.Dokument.Definicja.DrukujTylkoRoznicePrzedKorekta || pozycjaOryginalna.Korygowana;
            
            if( drukuj ) {
                przed_body.EditValue =
                    "|" + Right( ++fvc, 3 ) +
                    "|" + Left( pozycja.NazwaPierwszaLinia, 40 ) +
                    "|" + Right( pozycja.Cena, 16 ) +
                    "|" + Right( pozycja.Ilosc.Value, 10 ) +
                    " " + Left( pozycja.Ilosc.Symbol, 4 ) +
                    "|" + Right( pozycja.Rabat, 6 ) +
                    "|" + Right( pozycja.WartoscCy, 16 ) +
                    "|" + Center( pozycja.DefinicjaStawki, 10 ) +
                    "|" + Left( pozycja.SWW, 15 ) +
                    "|";
            } else {
                przed_body.EditValue = String.Empty;
            }
		}

		void PoBodyRepeater_BeforeRow(Object sender, EventArgs e)
		{
			PozycjaDokHandlowego pozycja = (PozycjaDokHandlowego)PoBodyRepeater.CurrentRow;

            bool drukuj = !pozycja.Dokument.Definicja.DrukujTylkoRoznicePoKorekcie || pozycja.Korygowana;

            if( !drukuj ) {
                po_body.EditValue = "";
            } else {
                po_body.EditValue =
                    "|" + Right( ++poc, 3 ) +
                    "|" + Left( pozycja.NazwaPierwszaLinia, 40 ) +
                    "|" + Right( pozycja.Cena, 16 ) +
                    "|" + Right( pozycja.ZmianaIlości.Value, 10 ) +
                    " " + Left( pozycja.ZmianaIlości.Symbol, 4 ) +
                    "|" + Right( pozycja.Rabat, 6 ) +
                    "|" + Right( pozycja.ZmianaWartościCy, 16 ) +
                    "|" + Center( pozycja.DefinicjaStawki, 10 ) +
                    "|" + Left( pozycja.SWW, 15 ) +
                    "|";
            }
		}

		void _Vat()
		{
			string left = Left("", 57);

			string body = "";
			foreach (SumaVAT vat in dokument.SumyVAT)
				body +=
					@"<pre style=""line-height: 1; margin: 0 0 0 0;"">" + left +
					"|" + Center(vat.DefinicjaStawki, 14) +
					"|" + Right(vat.Suma.Netto.ToString("n", CultureInfo.CurrentCulture), 18) +
					"|" + Right(vat.Suma.VAT.ToString("n", CultureInfo.CurrentCulture), 18) +
					"|" + Right(vat.Suma.Brutto.ToString("n", CultureInfo.CurrentCulture), 18) +
					"|" + System.Environment.NewLine +
					"</pre>";

			vat_body.EditValue = body;

			vat_footer.EditValue =
				@"<pre style=""line-height: 1; margin: 0 0 0 0;"">" + left +
					"|" + Center("Suma:", 14) +
					"|" + Right(dokument.Suma.Netto.ToString("n", CultureInfo.CurrentCulture), 18) +
					"|" + Right(dokument.Suma.VAT.ToString("n", CultureInfo.CurrentCulture), 18) +
					"|" + Right(dokument.Suma.Brutto.ToString("n", CultureInfo.CurrentCulture), 18) +
					"|" + System.Environment.NewLine +
				"</pre>";
		}

		bool innyPlatnik;
		int plc;

		void _Płatności()
		{
			//Wyliczamy informacje dla płatności
			if (dokument.Wydruk.SąNiezapłacone)
			{

				PlBodyRepeater.DataSource = dokument.Wydruk.Niezapłacone;

				string ss = @"<small><pre style=""line-height: 1; margin: 0 0 0 0;"">" + System.Environment.NewLine + "+---+----------------+------------+----------------+";
				if (innyPlatnik)
					ss += "-----------------------------------------------+";
				ss += System.Environment.NewLine + "</pre></small>";
				pl_header.EditValue =
					ss +
					@"<small><pre style=""line-height: 1; margin: 0 0 0 0;"">" +
					"|Lp." +
					"|" + Center("Sposób zapłaty", 16) +
					"|" + Center("Termin", 12) +
					"|" + Center("Kwota", 16) +
					(innyPlatnik ? "| " + Center("Płatnik", 46) : "") +
					"|" + System.Environment.NewLine +
					"</pre></small>" +
					ss;

				pl_footer.EditValue = ss;
			}
		}

		void PlBodyRepeater_BeforeRow(Object sender, EventArgs e)
		{
			WydrukDokumentu.NiezapłaconeInfo pl = (WydrukDokumentu.NiezapłaconeInfo)PlBodyRepeater.CurrentRow;

			string i1 = "";
			string i2 = "";

			if (innyPlatnik)
				if (pl.Płatność.Podmiot != pl.Płatność.Dokument.Podmiot)
				{
					i1 = "| " + Left(pl.Płatność.Podmiot.Nazwa, 46);
					i2 = "| " + Left(pl.Płatność.Podmiot.Adres, 46);
				}
				else
				{
					i1 = "| " + Left("", 46);
					i2 = i1;
				}

			string ss =
				@"<small><pre style=""line-height: 1; margin: 0 0 0 0;"">" +
				"|" + Right(++plc, 3) +
				"|" + Center(pl.Płatność.SposobZaplaty, 16) +
				"|" + Center(pl.Płatność.Termin, 12) +
				"|" + Right(pl.Kwota, 16) +
				i1 +
				"|" + System.Environment.NewLine + "</pre></small>";

			if (innyPlatnik)
				ss +=
				@"<small><pre style=""line-height: 1; margin: 0 0 0 0;"">" +
				"|   " +
				"|" + Left("", 16) +
				"|" + Left("", 12) +
				"|" + Left("", 16) +
				i2 +
				"|" + System.Environment.NewLine + "</pre></small>";

			pl_body.EditValue = ss;
		}

		Currency sumaZaliczek;

		void DokZalRepeater_BeforeRow(Object sender, EventArgs e)
		{
			DokumentHandlowy dok = (DokumentHandlowy)DokZalRepeater.CurrentRow;

			sumaZaliczek += dok.BruttoCy;

			DokZalItem.EditValue =
				"|" + Right(++plc, 3) +
				"|" + Left(dok, 36) +
				"|" + Center(dok.Data, 12) +
				"|" + Right(dok.BruttoCy, 18) +
				"|";

			DokZalSum.EditValue =
				"|   " +
				"|             S U M A :              " +
				"|            " +
				"|" + Right(sumaZaliczek, 18) +
				"|";
		}

		void ZalRepeater_BeforeRow(Object sender, EventArgs e)
		{
			RelacjaZaliczki rel = (RelacjaZaliczki)ZalRepeater.CurrentRow;

			ZalItem.EditValue =
				"|" + Right(++plc, 3) +
				"|" + Center(rel.Zaplata.SposobZaplaty, 16) +
				"|" + Center(rel.Zaplata.DataDokumentu, 12) +
				"|" + Right(rel.Kwota, 16) +
				"|" + Left(rel.Zaplata.NumerDokumentu, 26) +
				"|";
		}

		void _Stopka(string nazwa)
		{
			Divider8.EditValue = divider;

			Stopka.EditValue =
				@"<pre style=""line-height: 1; margin: 0 0 0 0;"">" +
				Center(dokument.Wydruk.UprawnionyDoWystawienia.FullName, 40) + "| " + Center(dokument.Osoba, 38) + "<br>" +
				Left("", 40) + "|<br>" +
				Left("", 40) + "|<br>" +
				Center("..............................", 40) + "| " + Center("..............................", 38) + "<br>" +
				Center("Podpis osoby uprawnionej", 40) + "|  " + Center("Podpis osoby upoważnionej", 38) + "<br>" +
				Center("do wystawienia " + nazwa, 40) + "|  " + Center("do otrzymania " + nazwa, 38) +
				"</pre>";

			Copyright.EditValue =
				"<small>" +
				@"<pre style=""line-height: 1; margin: 0 0 0 0;"">" +
				Right(dc.Copyright, 130) +
				"</pre>" +
				"</small>";
		}

		//Metody pomocnicze
		static string Center(object value, int len)
		{
			string ss = value.ToString();
			if (ss.Length >= len)
				return ss.Substring(0, len);
			int delta = len - ss.Length;
			int a = delta / 2;
			return ss.PadRight(ss.Length + a).PadLeft(len);
		}

		static string Left(object value, int len)
		{
			string ss = value.ToString();
			if (ss.Length > len)
				return ss.Substring(0, len);
			return ss.PadRight(len);
		}

		static string Right(object value, int len)
		{
			string ss = value.ToString();
			if (ss.Length > len)
				return ss.Substring(0, len);
			return ss.PadLeft(len);
		}

		static string Clip(object value, int len)
		{
			string ss = value.ToString();
			if (ss.Length > len)
				return ss.Substring(0, len);
			return ss;
		}

	</script>

	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
	<meta content="C#" name="CODE_LANGUAGE" />
	<meta content="JavaScript" name="vs_defaultClientScript" />
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
	<font face="Courier New" size="smaller">
        <form id="Zakup" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextloading="OnContextLoading"
                oncontextload="OnContextLoad"></ea:datacontext><ea:datalabel id="DataLabel1" runat="server" DataMember="Definicja.TytulWydruku">
                </ea:datalabel><ea:datalabel id="DataLabel2" runat="server" DataMember="Wydruk.MalyPodatnik_Do_20130101">
                <ValuesMap>
                    <ea:ValuesPair Key="False" Value="" />
                    <ea:ValuesPair Key="True" Value=" MP " />
                </ValuesMap>
            </ea:datalabel>&nbsp;<b><ea:datalabel id="DataLabel3" runat="server" DataMember="Numer"></ea:datalabel>
                <% if (duplikat) { %>
                DUPLIKAT
                <% } %>
            </b>

        <ea:DataLabel ID="DataLabel43" runat="server" DataMember="Wydruk.MalyPodatnik_Od_20130101" >
            <ValuesMap>
                <ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
                <ea:ValuesPair Key="True" Value="<br /><span style='font-size: 13px;'>metoda kasowa</span>"></ea:ValuesPair>
            </ValuesMap>
        </ea:DataLabel>

		<ea:DataLabel runat="server" DataMember="Stan" ID="stanLabel">
			<ValuesMap>
				<ea:ValuesPair Key="Anulowany" Value="&lt;br&gt;Dokument został anulowany"></ea:ValuesPair>
				<ea:ValuesPair Key="Bufor" Value="&lt;br&gt;Dokument nie został zatwierdzony"></ea:ValuesPair>
				<ea:ValuesPair Key="Zablokowany" Value=""></ea:ValuesPair>
				<ea:ValuesPair Key="Zatwierdzony" Value=""></ea:ValuesPair>
			</ValuesMap>
		</ea:DataLabel>
		<br>

            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleData) { %>
			&nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" NonBreakSpace="True" id="lDataEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
			<ea:datalabel id="lData" runat="server" DataMember="Wydruk.DatyDokumentu.Data"></ea:datalabel><br>
            <% } %> 

            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleDataOperacji) { %>
			&nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" NonBreakSpace="True" id="lDataOperacjiEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
			<ea:datalabel id="lDataOperacji" runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji"></ea:datalabel><br>
            <% } %> 

            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleDataOtrzymania) { %>
			&nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOtrzymaniaEtykieta" NonBreakSpace="True" id="lDataOtrzymaniaEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
			<ea:datalabel id="lDataOtrzymania" runat="server" DataMember="Wydruk.DatyDokumentu.DataOtrzymania"></ea:datalabel><br>
            <% } %> 

            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleDataDostawy) { %>
			&nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataDostawyEtykieta" NonBreakSpace="True" id="lDataDostawyEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
			<ea:datalabel id="lDataDostawy" runat="server" DataMember="Wydruk.DatyDokumentu.DataDostawy"></ea:datalabel><br>
            <% } %> 
            
			<% if (duplikat) { %>
			&nbsp;&nbsp;&nbsp;&nbsp;<i>Data wystawienia duplikatu:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i>
			<%= Date.Today%>
			<br>
			<% } %>


		<% if (dokument.DokumentKorygowany != null)
	 { %>
		<i>Dokument korygowany:----------------------------------------------------------</i><br>
		<ea:datarepeater runat="server" rowtypename="Soneta.Handel.DokumentHandlowy,Soneta.Handel" DataMember="DokumentyKorygowanePierwsze">
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel runat="server" DataMember="Numer"></ea:datalabel>
				 <ea:Section  ID="ObcyKorygowany" runat="server" EncodeHTML="True">
					<br />
						<span style="font-weight: normal; font-size: 13px;" >
							Dokument obcy nr:                                          
						<ea:DataLabel runat="server" DataMember="Obcy.Numer" EncodeHTML="True">
						</ea:DataLabel>
						</span>
					</ea:Section>
                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" NonBreakSpace="True" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.Data"></ea:datalabel>
                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" NonBreakSpace="True" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji"></ea:datalabel>
                <br />
            </ea:DataRepeater>
		<% } %>
		<i>Sprzedawca:-------------------------------------------------------------------</i><br>
		<ea:datalabel id="DataLabel14" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
        <ea:datalabel id="DataLabel15" runat="server" EncodeHTML="True" LeftMargin="4"></ea:datalabel><br>
        <ea:datalabel id="DataLabel16" runat="server" EncodeHTML="True" LeftMargin="4"></ea:datalabel>
		<br />
		&nbsp;&nbsp;&nbsp;&nbsp;NIP:
		<ea:DataLabel ID="DataLabel17" runat="server" DataMember="DaneKontrahenta.EuVAT"
			EncodeHTML="True">
		</ea:DataLabel>
		<br />
		&nbsp;&nbsp;&nbsp;&nbsp;Numer rachunku:
		<ea:DataLabel ID="Datalabel12" runat="server" DataMember="Kontrahent.DomyslnyRachunek.Rachunek.Numer"
			EncodeHTML="True">
		</ea:DataLabel>
		<br />
		<i>Nabywca:----------------------------------------------------------------------</i><br>
		&nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel8" runat="server" EncodeHTML="True">
		</ea:DataLabel>
		<br />
		&nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel9" runat="server" EncodeHTML="True">
		</ea:DataLabel>
		<br />
		&nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel10" runat="server" EncodeHTML="True">
		</ea:DataLabel>
		<br />
		&nbsp;&nbsp;&nbsp;&nbsp;NIP:
		<ea:DataLabel ID="DataLabel11" runat="server" DataMember="Wydruk.NIP" EncodeHTML="True">
		</ea:DataLabel>
		<br/>
         &nbsp;&nbsp;&nbsp;<ea:DataLabel ID="BDOFirmyS" runat="server" Bold="False" EncodeHTML="True" >
         </ea:DataLabel>
        <br/>
		<small>
			<ea:Section ID="KursSection" runat="server" DataMember="Wydruk.JestWaluta" Width="100%">
				<font size="2">Kurs <strong>1 </strong>
					<ea:DataLabel ID="DataLabel31" runat="server" DataMember="BruttoCy.Symbol" EncodeHTML="True">
					</ea:DataLabel>
					&nbsp;=
					<ea:DataLabel ID="KursWaluty" runat="server" DataMember="KursWaluty" EncodeHTML="True">
					</ea:DataLabel>
					<strong>&nbsp;PLN</strong> z dnia
					<ea:DataLabel ID="DataLabel32" runat="server" DataMember="DataOgłoszeniaKursu" EncodeHTML="True">
					</ea:DataLabel>
					&nbsp; (
					<ea:DataLabel ID="DataLabel33" runat="server" DataMember="TabelaKursowa" EncodeHTML="True">
					</ea:DataLabel>
					)</font></ea:Section>
			<% if (dokument.DokumentKorygowany == null)
	  { %>
			<pre style="line-height: 1; margin: 0 0 0 0;">+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+
|Lp.|           Nazwa towaru/usługi          |   <%=clC   %>  |   Ilość   jm. | Rabat| <%=clW      %> |Stawka VAT|   SWW/PKWiU   |
+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+</pre>
			<ea:DataRepeater ID="FvBodyRepeater" runat="server" DataMember="Pozycje" OnBeforeRow="FvBodyRepeater_BeforeRow"
				Width="100%">
				<pre style="line-height: 1; margin: 0 0 0 0;">
<ea:DataLabel ID="fv_body" runat="server" EncodeHTML="True">
</ea:DataLabel></pre>
			</ea:DataRepeater>
			<br />
			<pre style="line-height: 1; margin: 0 0 0 0;">+---+----------------------------------------+-----------+----+---------+-----+------+-----+----------+-------+--+---------------+
</pre>
			<% }
	  else
	  { %>
			<pre style="line-height: 1; margin: 0 0 0 0;"><i>Przed korektą:</i>
+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+
|Lp.|           Nazwa towaru/usługi          |   <%=clC   %>  |   Ilość   jm. | Rabat| <%=clW      %> |Stawka VAT|   SWW/PKWiU   |
+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+</pre>
			<ea:DataRepeater ID="PrzedBodyRepeater" runat="server" DataMember="Pozycje" OnBeforeRow="PrzedBodyRepeater_BeforeRow"
				Width="100%">
				<pre style="line-height: 1; margin: 0 0 0 0;">
<ea:DataLabel ID="przed_body" runat="server" EncodeHTML="True">
</ea:DataLabel></pre>
			</ea:DataRepeater>
			<pre style="line-height: 1; margin: 0 0 0 0;">+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+
<i>Korekta:</i>
+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+
|Lp.|           Nazwa towaru/usługi          |   <%=clC   %>  | Zm.ilości jm. | Rabat| Zmiana wartości|Stawka VAT|   SWW/PKWiU   |
+---+----------------------------------------+----------------+---------------+------+----------------+----------+---------------+</pre>
			<ea:DataRepeater ID="PoBodyRepeater" runat="server" DataMember="Pozycje" OnBeforeRow="PoBodyRepeater_BeforeRow"
				Width="100%">
				<pre style="line-height: 1; margin: 0 0 0 0;">
<ea:DataLabel ID="po_body" runat="server" Bold="False" EncodeHTML="True">
</ea:DataLabel></pre>
			</ea:DataRepeater>
			<pre style="line-height: 1; margin: 0 0 0 0;">+---+----------------------------------------+-----------+----+---------+-----+------+-----+----------+-------+--+---------------+</pre>
			<% } %>
			<% if (dokument.Definicja.SumyVAT != SposobLiczeniaSumVAT.NieLiczyć)
	  { %>	<pre style="line-height: 1; margin: 0 0 0 0;">                                                         |  Stawka VAT  |    Kwota netto   |     Kwota VAT    |   Kwota Brutto   |
</pre>
			<pre style="line-height: 1; margin: 0 0 0 0;">                                                         +--------------+------------------+------------------+------------------+
</pre>
			<ea:DataLabel ID="vat_body" runat="server" EncodeHTML="false" />
			<pre style="line-height: 1; margin: 0 0 0 0;">                                                         +--------------+------------------+------------------+------------------+
</pre>
			<ea:DataLabel ID="vat_footer" runat="server" EncodeHTML="false" />
			<pre style="line-height: 1; margin: 0 0 0 0;">                                                         +--------------+------------------+------------------+------------------+
</pre>
			<% } %>
			<ea:Section ID="Section9" runat="server" DataMember="DokumentKorygowany" ConditionValue="IS NOT NULL">
				&nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel39" runat="server" DataMember="Wydruk.InfoKorekty1"
					EncodeHTML="True">
				</ea:DataLabel>
				<br>
				&nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel40" runat="server" DataMember="Wydruk.InfoKorekty2"
					EncodeHTML="True">
				</ea:DataLabel>
			</ea:Section>
		</small>
		<% if (dokument.Wydruk.JestSumaPozycji)
	 { %>
		<pre><i>Suma brutto dokumentu:</i></pre>
		<ea:DataLabel DataMember="SumaPozycji.Brutto" runat="server" ID="Datalabel22" EncodeHTML="True">
		</ea:DataLabel>
		PLN
		<% } %>
		<% if (dokument.DokumentyZaliczkowe.Length > 0)
	 {
		 plc = 0; %>
		<pre><i>Faktury zaliczkowe:</i></pre>
		<small>
			<pre>+---+------------------------------------+------------+------------------+
|Lp.|               Numer                |    Data    |      Wartość     |
+---+------------------------------------+------------+------------------+</pre>
			<ea:DataRepeater ID="DokZalRepeater" runat="server" OnBeforeRow="DokZalRepeater_BeforeRow">
				<pre>
<ea:DataLabel ID="DokZalItem" runat="server" Bold="False" EncodeHTML="True">
</ea:DataLabel></pre>
			</ea:DataRepeater>
			<pre>+---+------------------------------------+------------+------------------+
<ea:DataLabel ID="DokZalSum" runat="server" Bold="False" EncodeHTML="True">
</ea:DataLabel>
+---+------------------------------------+------------+------------------+
</pre>
		</small>
		<% } %>
		<br>
		<i>
			<ea:DataLabel ID="DataLabel22x" runat="server" DataMember="Wydruk.KierunekZapłaty"
				NonBreakSpace="True" Format="{0,20}:">
			</ea:DataLabel>
		</i><b>
			<ea:DataLabel ID="DataLabel23" runat="server" DataMember="BruttoCy" Format="{0:+u}"
				EncodeHTML="True">
			</ea:DataLabel>
		</b>
		<br>
		<i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Słownie:</i>
		<small>
			<ea:DataLabel ID="DataLabel24" runat="server" DataMember="BruttoCy" Format="{0:+t}"
				EncodeHTML="True">
			</ea:DataLabel>
		</small>
		<br>
		<% if (!dokument.Zaliczki.IsEmpty)
	 {
		 plc = 0; %>
		<pre><i>Rozliczone zaliczki:</i></pre>
		<small>
			<pre>+---+----------------+------------+----------------+--------------------------+
|Lp.| Sposób zapłaty |Data zapłaty|      Kwota     |           Numer          |
+---+----------------+------------+----------------+--------------------------+</pre>
			<ea:DataRepeater ID="ZalRepeater" runat="server" OnBeforeRow="ZalRepeater_BeforeRow">
				<pre>
<ea:DataLabel ID="ZalItem" runat="server" Bold="False" EncodeHTML="True">
</ea:DataLabel></pre>
			</ea:DataRepeater>
			<pre>+---+----------------+------------+----------------+--------------------------+</pre>
		</small>
		<% } %>
		<% if (dokument.Wydruk.ZapłataCzęściowa)
	 { %>
		<br>
		<ea:DataLabel runat="server" DataMember="Wydruk.Zapłacono" ID="Datalabel25" EncodeHTML="True">
		</ea:DataLabel>
		<ea:DataLabel runat="server" DataMember="Zapłata.SposobZaplaty.Biernik" ID="Datalabel26"
			EncodeHTML="True">
		</ea:DataLabel>
		: <b>
			<ea:DataLabel runat="server" DataMember="Zapłata.SłownieUpr" ID="Datalabel27" EncodeHTML="True">
			</ea:DataLabel>
		</b>
		<br>
		<% } %>
		<% if (dokument.Wydruk.ZapłataCałkowita)
	 { %>
		<br>
		<ea:DataLabel runat="server" DataMember="Wydruk.Zapłacono" ID="Datalabel28x" EncodeHTML="True">
		</ea:DataLabel>
		<ea:DataLabel runat="server" DataMember="Zapłata.SposobZaplaty.Biernik" ID="Datalabel29"
			EncodeHTML="True">
		</ea:DataLabel>
		<br>
		<% } %>
		<% if (dokument.Wydruk.SąNiezapłacone)
	 {
		 plc = 0; %>
		<br>
		<i>Pozostało do zapłaty:</i>
		<ea:DataLabel ID="pl_header" runat="server" Bold="False" EncodeHTML="False" />
			<ea:DataRepeater ID="PlBodyRepeater" runat="server" OnBeforeRow="PlBodyRepeater_BeforeRow"
			Width="100%">
			<ea:DataLabel ID="pl_body" runat="server" Bold="False" EncodeHTML="False" />
		</ea:DataRepeater>
		<ea:DataLabel ID="pl_footer" runat="server" Bold="False" EncodeHTML="False" />
		<% } %>
		<p>
			<ea:DataLabel runat="server" DataMember="Opis" Bold="False" ID="DataLabel27x">
			</ea:DataLabel>
		</p>
		<p>
			<ea:DataLabel runat="server" DataMember="Wydruk.OpisWydruku" Bold="False" ID="DataLabel28">
			</ea:DataLabel>
		</p>
		<br>
		<br>
		<ea:DataLabel ID="Divider8" runat="server" Bold="False" EncodeHTML="false" />
		<br>
		<ea:DataLabel ID="Stopka" runat="server" Bold="False" EncodeHTML="False" />
		<br>
		<ea:DataLabel ID="Copyright" runat="server" Bold="False" EncodeHTML="False" />
		<ea:PageBreak ID="PageBreak1" runat="server">
		</ea:PageBreak>
	</form>
</body>
</html>

